import os

from setuptools import setup, Extension

try:
    # Kompilacja z kodu źródłowego na kod źródłowy
    # za pomocą Cythona jest używana tylko wtedy, gdy 
    # Cython jest dostępny...
    import Cython

    # ...i określona zmienna środowiskowa 
    # bezpośrednio informuje, że należy użyć Cythona do
    # wygenerowania kodu źródłowego w C.
    USE_CYTHON = bool(os.environ.get("USE_CYTHON"))

except ImportError:
    USE_CYTHON = False

ext = ".pyx" if USE_CYTHON else ".c"

extensions = [Extension("fibonacci", ["fibonacci" + ext])]

if USE_CYTHON:
    from Cython.Build import cythonize

    extensions = cythonize(extensions)

setup(
    name="fibonacci",
    ext_modules=extensions,
    extras_require={
        # Jeśli pakiet jest instalowany z opcją
        # '[with-cython]', wymagana jest 
        # podana tu wersja Cythona.
        "with-cython": ["cython==0.29.22"]
    },
)
